<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

class Update94 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $table = $schema->getTable('pongho_apps');

        if (!$table->hasColumn('load_order')) {
            $table->addColumn('load_order', 'integer', ['unsigned' => true, 'default' => 0]);
        }
    }
}
