<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Model\Translation;
use Updates\BaseUpdate;

class Update9 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        Translation::addTranslation('users_configuration', 'Configurazione utenti', 'admin', null, 'it_IT');
        Translation::addTranslation('default_language_explain', 'Indica quale lingua utilizzare se nessuno dei 3 parametri (url della pagina, configurazione utente e browser) riescono a definire la lingua da utilizzare.', 'admin', null, 'it_IT');
        Translation::addTranslation('recaptcha_private_key_explain', 'Chiavi di default globali (multi dominio) Meta Line, qualora si rendesse necessario modificare le chiavi o usare delle chiavi specifiche per un sito, l\'amministrazione di reCAPTCHA la puoi trovare al seguente indirizzo: <a href="https://www.google.com/recaptcha/admin/list" target="_blank">https://www.google.com/recaptcha/admin/list</a>', 'admin', null, 'it_IT');
    }
}
