<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Model\Application;
use Application\Core\Model\ApplicationSite;
use Application\Core\Model\Site;
use Updates\BaseUpdate;

class Update87 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        $sql = 'INSERT INTO ' . ApplicationSite::tableName() . ' (app_id, site_id)
SELECT a.id AS app_id, s.id AS site_id
FROM ' . Application::tableName() . ' AS a
CROSS JOIN ' . Site::tableName() . ' AS s
WHERE is_installed = :installed AND is_enabled = :enabled';

        $this->connection->executeQuery($sql, ['enabled' => true, 'installed' => true]);
    }
}
