<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

class Update86 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $table = $schema->createTable('pongho_apps_sites');
        $table->addColumn('app_id', 'integer', ['unsigned' => true]);
        $table->addColumn('site_id', 'integer', ['unsigned' => true]);
        $table->addForeignKeyConstraint($schema->getTable('pongho_apps'), ['app_id'], ['id']);
        $table->addForeignKeyConstraint($schema->getTable('pongho_sites'), ['site_id'], ['id']);
    }
}
