<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Model\Account;
use Pongho\Utilities\DateTime;
use Updates\BaseUpdate;

class Update7 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        foreach (Account::all(['conditions' => ['id <> :id', 'id' => 1]]) as $account) {
            $timestamp = '0';
            if ($account->created_at instanceof DateTime) {
                $timestamp = $account->created_at->format('U');
            }

            $account->url = $timestamp . random(8, '0123456789');

            $account->save(false);
        }
    }
}
