<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Updates\BaseUpdate;

class Update61 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        $platform_name = $this->connection->getDatabasePlatform()->getName();

        match ($platform_name) {
            'mysql' => $this->connection->executeStatement(
                'ALTER TABLE pongho_addresses CHANGE province province_name VARCHAR(100)',
            ),
            'postgresql' => $this->connection->executeStatement(
                'ALTER TABLE pongho_addresses RENAME COLUMN province TO province_name',
            ),
            default => throw new \Exception(sprintf('Database "%s" is not supported.', $platform_name)),
        };
    }
}
