<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

class Update60 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $users_table = $schema->getTable('pongho_users');
        $addresses_table = $schema->getTable('pongho_addresses');

        if (!$users_table->hasColumn('address2')) {
            $users_table->addColumn('address2', 'text', ['length' => 255, 'default' => '']);
        }

        if (!$addresses_table->hasColumn('province_id')) {
            $addresses_table->addColumn('province_id', 'integer', ['unsigned' => true, 'notnull' => false]);
        }
    }
}
