<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Model\Application;
use Updates\BaseUpdate;

class Update3 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        if (!Application::count()) {
            $kernels_path = PONGHO_PATH . '/Application/*/Kernel.php';
            $base_path_length = strlen(PONGHO_PATH) + 1;

            foreach (glob($kernels_path) as $kernel_file) {
                $kernel_class = str_replace('/', '\\', substr($kernel_file, $base_path_length, -4));

                $segments = explode('\\', $kernel_class);
                $app_name = $segments[1];

                if (defined("{$kernel_class}::VERSION")) {
                    Application::create([
                        'app_name'     => $app_name,
                        'app_version'  => $kernel_class::VERSION,
                        'is_installed' => true,
                        'is_enabled'   => true,
                    ]);
                }
            }
        }
    }

    /**
     * {@inheritdoc}
     */
    public function rollback(\Exception $prev)
    {
        $platform = $this->connection->getDatabasePlatform();
        $sql = $platform->getTruncateTableSQL('pongho_apps');
        $this->connection->executeStatement($sql);
    }
}
