<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

class Update28 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        // The cleanup update

        // Rimuovo le tabelle dei Reminder se questi non sono presenti nel sito
        if (!file_exists(__DIR__ . '/../../Reminder/Kernel.php')) {
            if ($schema->hasTable('pongho_reminders')) {
                $schema->dropTable('pongho_reminders');
            }

            if ($schema->hasTable('pongho_reminders_types')) {
                $schema->dropTable('pongho_reminders_types');
            }
        }
    }
}
