<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Installer\Helper\DatabaseSchemaHelper;
use Doctrine\DBAL\Schema\Schema;
use Updates\BaseUpdate;

/**
 * Update222
 *
 * Crea la tabella 'banned_emails'.
 */
final class Update222 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        (new DatabaseSchemaHelper($this->connection))->update(function (Schema $schema, DatabaseSchemaHelper $helper): void {
            if ($schema->hasTable('pongho_banned_emails')) {
                return;
            }

            $bannedEmailsTable = $schema->createTable('pongho_banned_emails');
            $helper->addPrimaryKey($bannedEmailsTable);
            $helper->addStringColumn($bannedEmailsTable, 'match_type');
            $helper->addStringColumn($bannedEmailsTable, 'match_compare');
        });
    }
}
