<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Installer\Helper\DatabaseSchemaHelper;
use Doctrine\DBAL\Schema\Schema;
use Updates\BaseUpdate;

/**
 * Update221
 *
 * Rimuove gli aggiornamenti di Update219
 */
final class Update221 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        (new DatabaseSchemaHelper($this->connection))->update(function (Schema $schema, DatabaseSchemaHelper $helper): void {
            $modulesTable = $schema->getTable('pongho_modules');

            if ($modulesTable->hasColumn('has_segments')) {
                $modulesTable->dropColumn('has_segments');
            }
        });
    }
}
