<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Installer\Helper\TranslationsHelper;
use Updates\BaseUpdate;

/**
 * Update220
 *
 * Aggiunge la traduzione 'email_datetime_send'
 */
final class Update220 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        (new TranslationsHelper($this->connection))
            ->setCulture('it_IT')
            ->addTranslation('email_datetime_send', 'E-mail inviata il %s alle %s', 'user');
    }
}
