<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Installer\Helper\DatabaseSchemaHelper;
use Doctrine\DBAL\Schema\Schema;
use Updates\BaseUpdate;

/**
 * Update215
 *
 * Aggiunge la colonna `position` alle tabelle dei ruoli e dei gruppi, in modo da poterli ordinare.
 */
final class Update215 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        (new DatabaseSchemaHelper($this->connection))->update(function (Schema $schema, DatabaseSchemaHelper $helper): void {
            $rolesTable = $schema->getTable('pongho_roles');
            $groupsTable = $schema->getTable('pongho_groups');

            if (!$rolesTable->hasColumn('position')) {
                $helper->addIntegerColumn($rolesTable, 'position', false);
            }

            if (!$groupsTable->hasColumn('position')) {
                $helper->addIntegerColumn($groupsTable, 'position', false);
            }
        });
    }
}
