<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Installer\Helper\DatabaseSchemaHelper;
use Application\Core\Installer\Helper\TranslationsHelper;
use Doctrine\DBAL\Schema\Schema;
use Updates\BaseUpdate;

/**
 * Update214
 *
 * Aggiunge i campi 'sdi_code' e 'pec' nel profilo utente.
 */
final class Update214 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        (new DatabaseSchemaHelper($this->connection))->update(function (Schema $schema): void {
            $usersTable = $schema->getTable('pongho_users');

            $usersTable->addColumn('sdi_code', 'string', ['length' => 50, 'default' => '']);
            $usersTable->addColumn('pec', 'string', ['length' => 50, 'default' => '']);
        });

        (new TranslationsHelper($this->connection))
            ->setCulture('it_IT')
            ->addTranslation('invalid_pec_format', 'L’indirizzo PEC inserito non è corretto!', 'messages')
            ->addTranslation('invalid_sdi_code_format', 'Il Codice di invio (SdI) inserito non è valido!', 'messages')
            ->addTranslation('required_sdi_code', 'Il campo “Codice di invio (SdI)” è obbligatorio!', 'messages')
            ->addTranslation('sdi_code', 'Codice di invio (SdI)', 'core');
    }
}
