<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Installer\Helper\TranslationsHelper;
use Updates\BaseUpdate;

/**
 * Update210
 *
 * Traduzioni degli errori per il caricamento dei file.
 */
class Update210 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        $helper = new TranslationsHelper($this->connection);
        $helper->setCulture('it_IT');

        $helper->removeTranslation('fileuploader_error_empty_result');
        $helper->addTranslation('fileuploader_error_empty_file', 'Il file caricato sembra vuoto', 'messages');

        $helper->changeApplication('fileuploader_error_allowed_extensions', 'messages');
        $helper->changeApplication('fileuploader_error_max_file_size', 'messages');
        $helper->changeApplication('fileuploader_error_max_number_of_files', 'messages');
        $helper->changeApplication('fileuploader_error_min_file_size', 'messages');
        $helper->changeApplication('fileuploader_error_upload', 'messages');
        $helper->changeApplication('fileuploader_error_uploaded_bytes', 'messages');
    }
}
