<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Installer\Helper\DatabaseSchemaHelper;
use Doctrine\DBAL\Schema\Schema;
use Updates\BaseUpdate;

/**
 * Update207
 *
 * Supporto a Cc e Bcc nelle notifiche.
 */
class Update207 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        (new DatabaseSchemaHelper($this->connection))->update(function (Schema $schema): void {
            $table = $schema->getTable('pongho_notifications_templates');
            $table->addColumn('cc_to_admin', 'string', ['length' => 255, 'default' => '']);
            $table->addColumn('bcc_to_admin', 'string', ['length' => 255, 'default' => '']);
            $table->addColumn('cc_to_user', 'string', ['length' => 255, 'default' => '']);
            $table->addColumn('bcc_to_user', 'string', ['length' => 255, 'default' => '']);
        });
    }
}
