<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Installer\Helper\DatabaseSchemaHelper;
use Doctrine\DBAL\ParameterType;
use Doctrine\DBAL\Schema\Schema;
use Updates\BaseUpdate;

/**
 * Update203
 *
 * Aggiorna i dati nella tabella dei paesi
 */
class Update203 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        (new DatabaseSchemaHelper($this->connection))->update(function (Schema $schema): void {
            $countriesTable = $schema->getTable('pongho_countries');

            if (!$countriesTable->hasColumn('phone_code')) {
                $countriesTable->addColumn('phone_code', 'string', ['length' => 50, 'default' => '']);
            }

            if (!$countriesTable->hasColumn('currency_name')) {
                $countriesTable->addColumn('currency_name', 'string', ['length' => 50, 'default' => '']);
            }

            if (!$countriesTable->hasColumn('currency_code')) {
                $countriesTable->addColumn('currency_code', 'string', ['length' => 10, 'default' => '']);
            }

            if (!$countriesTable->hasColumn('currency_number')) {
                $countriesTable->addColumn('currency_number', 'string', ['length' => 10, 'default' => '']);
            }

            if (!$countriesTable->hasColumn('currency_decimals')) {
                $countriesTable->addColumn('currency_decimals', 'integer', ['length' => 2, 'default' => 0]);
            }
        });

        $this->updateCountries();
    }

    private function updateCountries()
    {
        $stm = 'UPDATE pongho_countries SET name = :name, phone_code = :phone_code, currency_name = :currency_name, currency_code = :currency_code, currency_number = :currency_number, currency_decimals = :currency_decimals WHERE code = :code';
        $sth = $this->connection->prepare($stm);

        $countriesFile = __DIR__ . '/../Installer/Resources/countries.json';
        foreach (json_decode(file_get_contents($countriesFile), true) as $country) {
            $sth->bindValue('name', $country['name']);
            $sth->bindValue('code', $country['code']);
            $sth->bindValue('phone_code', $country['phone_code']);
            $sth->bindValue('currency_name', $country['currency_name']);
            $sth->bindValue('currency_code', $country['currency_code']);
            $sth->bindValue('currency_number', $country['currency_number']);
            $sth->bindValue('currency_decimals', $country['currency_decimals'], ParameterType::INTEGER);

            $sth->executeStatement();
        }
    }
}
