<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

class Update2 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        if (!$schema->hasTable('pongho_apps')) {
            $table = $schema->createTable('pongho_apps');
            $table->addColumn('id', 'integer', ['unsigned' => true, 'autoincrement' => true]);
            $table->addColumn('app_name', 'string', ['length' => 50]);
            $table->addColumn('app_version', 'string', ['length' => 20]);
            $table->addColumn('is_installed', 'boolean');
            $table->addColumn('is_enabled', 'boolean');
            $table->setPrimaryKey(['id']);
        }
    }
}
