<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Installer\Helper\PermissionsHelper;
use Updates\BaseUpdate;

/**
 * Update199.
 *
 * Aggiunge il permesso per visualizzare gli utenti
 */
class Update199 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        (new PermissionsHelper($this->connection))->addPermission('users.view');
    }
}
