<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Doctrine\DBAL\ParameterType;
use Updates\BaseUpdate;

/**
 * Update192
 *
 * Si assicura che tutte le email degli utenti siano in lowercase
 */
class Update192 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        $sql = 'SELECT id, email, username FROM pongho_users WHERE id <> 1';

        foreach ($this->connection->fetchAllAssociative($sql) as $row) {
            $data = [
                'email' => strtolower((string) $row['email']),
            ];

            if (preg_match('/^[a-z0-9&\'\.\-_\+]+@[a-z0-9\-]+\.([a-z0-9\-]+\.)*?[a-z]+$/is', (string) $row['username'])) {
                $data['username'] = strtolower((string) $row['username']);
            }

            $this->connection->update(
                'pongho_users',
                $data,
                [
                    'id' => $row['id'],
                ],
                [
                    'id'       => ParameterType::INTEGER,
                    'email'    => ParameterType::STRING,
                    'username' => ParameterType::STRING,
                ]
            );
        }
    }
}
