<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Installer\Helper\TranslationsHelper;
use Updates\BaseUpdate;

/**
 * Update190
 *
 * Traduzioni.
 */
class Update190 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        $helper = new TranslationsHelper($this->connection);

        $helper
            ->removeTranslation('apps_settings')

            ->removeTranslation('groups_title')
            ->removeTranslation('groups_explain')
            ->removeTranslation('group')
            ->removeTranslation('add_group')
            ->removeTranslation('add_first_group')

            ->removeTranslation('settings_languages_title')
            ->removeTranslation('installed_languages_explain')
            ->removeTranslation('iso')
            ->removeTranslation('culture')
            ->removeTranslation('locale')
            ->removeTranslation('timezone')

            ->removeTranslation('languages_title')
            ->removeTranslation('enabled_languages_explain')
            ->removeTranslation('language')

            ->removeTranslation('options_title')
            ->removeTranslation('site_configuration')
            ->removeTranslation('slogan')
            ->removeTranslation('site_domain')
            ->removeTranslation('default_language')
            ->removeTranslation('default_language_explain')
            ->removeTranslation('users_configuration')
            ->removeTranslation('subscription_mode')
            ->removeTranslation('subscription_mode_simple')
            ->removeTranslation('subscription_mode_email')
            ->removeTranslation('account_url')
            ->removeTranslation('account_url_enable_explain')
            ->removeTranslation('recaptcha')
            ->removeTranslation('recaptcha_explain')
            ->removeTranslation('recaptcha_private_key')
            ->removeTranslation('recaptcha_private_key_explain')
            ->removeTranslation('recaptcha_public_key')

            ->removeTranslation('documentation')
            ->removeTranslation('telephone_2')
            ->removeTranslation('telephone_3')
            ->removeTranslation('fax_2')
            ->removeTranslation('fax_3')
            ->removeTranslation('copyright')

            ->removeTranslation('social_configuration')
            ->removeTranslation('fb')
            ->removeTranslation('fb_explain')
            ->removeTranslation('fb_comments')
            ->removeTranslation('fb_comments_explain')
            ->removeTranslation('fb_appid')
            ->removeTranslation('fb_appsecret')
            ->removeTranslation('fb_admin_id')
            ->removeTranslation('fb_admin_id_explain')
            ->removeTranslation('fb_og_type')

            ->removeTranslation('users_export_title')
            ->removeTranslation('users_import_title')
            ->removeTranslation('users_import_explain')
            ->removeTranslation('file_import')
            ->removeTranslation('file_import_explain')
            ->removeTranslation('load')
            ->removeTranslation('import')
        ;
    }
}
