<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Installer\Helper\PermissionsHelper;
use Application\Core\Installer\Helper\TranslationsHelper;
use Updates\BaseUpdate;

/**
 * Update187
 *
 * Corregge un po' di permessi.
 */
class Update187 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        $this->fixPermissions();
        $this->fixTranslations();
    }

    private function fixPermissions()
    {
        $helper = new PermissionsHelper($this->connection);

        $helper->removePermission('admin.options');
    }

    private function fixTranslations()
    {
        $helper = new TranslationsHelper($this->connection);
        $helper->setCulture('it_IT');

        $helper->addTranslation('permit_ns_admin.options', 'Opzioni', 'admin');

        $helper->changeTranslation('permit_admin.options.notifications', 'Template notifiche');
        $helper->changeTranslation('permit_admin.options.translations', 'Traduzioni');
    }
}
