<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Installer\Helper\DatabaseSchemaHelper;
use Doctrine\DBAL\Schema\Schema;
use Updates\BaseUpdate;

class Update185 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        (new DatabaseSchemaHelper($this->connection))->update(function (Schema $schema): void {
            if ($schema->hasTable('pongho_cron_tasks')) {
                return;
            }

            $table = $schema->createTable('pongho_cron_tasks');

            $table->addColumn('id', 'integer', ['unsigned' => true, 'autoincrement' => true]);
            $table->addColumn('service_name', 'string', ['length' => 200, 'default' => '']);
            $table->addColumn('data', 'text', ['length' => 65535, 'default' => '']);
            $table->addColumn('created_at', 'datetime');
            $table->addColumn('attempts', 'integer', ['unsigned' => true, 'default' => 0]);
            $table->addColumn('last_attempt_at', 'datetime', ['notnull' => false, 'default' => null]);
            $table->addColumn('executed_at', 'datetime', ['notnull' => false, 'default' => null]);
            $table->setPrimaryKey(['id']);
        });
    }
}
