<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

class Update173 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $users_table = $schema->getTable('pongho_users');

        if (!$users_table->hasColumn('expire_at')) {
            $users_table->addColumn('expire_at', 'datetime', ['notnull' => false]);
        }
    }
}
