<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Doctrine\DBAL\Schema\Schema;
use Updates\SchemaUpdate;

class Update142 extends SchemaUpdate
{
    /**
     * {@inheritdoc}
     */
    protected function prepareSchema(Schema $schema)
    {
        $table = $schema->getTable('pongho_regions');

        if (!$table->hasColumn('country_id')) {
            $table->addColumn('country_id', 'integer', ['unsigned' => true, 'notnull' => false, 'default' => null]);
        }
    }
}
