<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Model\Country;
use Doctrine\DBAL\ParameterType;
use Updates\BaseUpdate;

class Update140 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        /** @var Country[] $countries */
        $countries = [];

        /** @var Country $country */
        foreach (Country::all() as $country) {
            $countries[$country->name] = $country;
        }

        foreach (json_decode(file_get_contents(PONGHO_PATH . '/Application/Core/Installer/Resources/countries.json'), true) as $row) {
            if (array_key_exists($row['name'], $countries)) {
                if (empty($countries[$row['name']]->code)) {
                    $countries[$row['name']]->code = $row['code'];
                }

                if (empty($countries[$row['name']]->code3)) {
                    $countries[$row['name']]->code3 = $row['code3'];
                }

                if (empty($countries[$row['name']]->num)) {
                    $countries[$row['name']]->num = $row['num'];
                }

                if (empty($countries[$row['name']]->postal_name)) {
                    $countries[$row['name']]->postal_name = $row['postal_name'];
                }

                if (empty($countries[$row['name']]->address_template)) {
                    $countries[$row['name']]->address_template = $row['address_template'];
                }

                $countries[$row['name']]->save();
            } else {
                $this->connection->insert(
                    'pongho_countries',
                    [
                        'name'             => $row['name'] ?? '',
                        'code'             => $row['code'] ?? '',
                        'code3'            => $row['code3'] ?? '',
                        'num'              => $row['num'] ?? '',
                        'postal_name'      => $row['postal_name'] ?? '',
                        'address_template' => $row['address_template'] ?? '',
                    ],
                    [
                        'name'             => ParameterType::STRING,
                        'code'             => ParameterType::STRING,
                        'code3'            => ParameterType::STRING,
                        'num'              => ParameterType::STRING,
                        'postal_name'      => ParameterType::STRING,
                        'address_template' => ParameterType::STRING,
                    ]
                );
            }
        }
    }
}
