<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Admin\Model\AdminModule;
use Application\Core\Model\Permit;
use Application\Core\Model\PermitRole;
use Application\Core\Model\Translation;
use Updates\BaseUpdate;

class Update14 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        // Aggiunta permessi user.(add|edit|delete|handle_groups|handle_roles)
        /** @var Permit $add_permit */
        $add_permit = Permit::create(['key' => 'users.add', 'is_enabled' => true]);
        /** @var Permit $edit_permit */
        $edit_permit = Permit::create(['key' => 'users.edit', 'is_enabled' => true]);
        /** @var Permit $delete_permit */
        $delete_permit = Permit::create(['key' => 'users.delete', 'is_enabled' => true]);
        /** @var Permit $groups_permit */
        $groups_permit = Permit::create(['key' => 'users.handle_groups', 'is_enabled' => true]);
        /** @var Permit $roles_permit */
        $roles_permit = Permit::create(['key' => 'users.handle_roles', 'is_enabled' => true]);

        if (class_exists(\Application\Admin\Kernel::class)) {
            // Correzione permessi in admin modules
            $users_panel = AdminModule::findPanel('users');

            /** @var AdminModule $item */
            $item = AdminModule::first(['conditions' => ['name = :name AND parent_id = :parent', 'name' => 'add_user', 'parent' => $users_panel->id]]);
            if ($item) {
                $item->permit_id = $add_permit->id;
                $item->save();
            }

            $item = AdminModule::first(['conditions' => ['name = :name AND parent_id = :parent', 'name' => 'groups', 'parent' => $users_panel->id]]);
            if ($item) {
                $item->permit_id = $groups_permit->id;
                $item->save();
            }

            $item = AdminModule::first(['conditions' => ['name = :name AND parent_id = :parent', 'name' => 'roles', 'parent' => $users_panel->id]]);
            if ($item) {
                $item->permit_id = $roles_permit->id;
                $item->save();
            }
        }

        // Assegno i permessi ai ruoli che avevano 'users.admin'
        $options = [
            'select'     => '`from`.*',
            'joins'      => 'INNER JOIN ' . Permit::tableName() . ' AS p ON p.id = `from`.permit_id',
            'conditions' => [
                'p.key = :key',
                'key' => 'users.admin',
            ],
        ];

        /** @var PermitRole $permit_role */
        foreach (PermitRole::all($options) as $permit_role) {
            PermitRole::create(['permit_id' => $add_permit->id, 'role_id' => $permit_role->role_id]);
            PermitRole::create(['permit_id' => $edit_permit->id, 'role_id' => $permit_role->role_id]);
            PermitRole::create(['permit_id' => $delete_permit->id, 'role_id' => $permit_role->role_id]);
            PermitRole::create(['permit_id' => $groups_permit->id, 'role_id' => $permit_role->role_id]);
            PermitRole::create(['permit_id' => $roles_permit->id, 'role_id' => $permit_role->role_id]);
        }

        // Aggiunta traduzioni chiavi permessi
        Translation::addTranslation('permit_users.add', 'Può aggiungere nuovi Utenti', 'core', null, 'it_IT');
        Translation::addTranslation('permit_users.edit', 'Può modificare gli Utenti', 'core', null, 'it_IT');
        Translation::addTranslation('permit_users.delete', 'Può eliminare gli Utenti', 'core', null, 'it_IT');
        Translation::addTranslation('permit_users.handle_groups', 'Può gestire i Gruppi', 'core', null, 'it_IT');
        Translation::addTranslation('permit_users.handle_roles', 'Può gestire i Ruoli', 'core', null, 'it_IT');

        echo '<span style="color: orange;">Sono stati modificati i permessi sugli utenti, controlla che sia tutto corretto</span><br>';
    }
}
