<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Model\Permit;
use Application\Core\Model\PermitRole;
use Application\Core\Model\Role;
use Application\Core\Model\Translation;
use Updates\BaseUpdate;

class Update126 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        // Modifico la chiave del permesso delle traduzioni per uniformarla
        if ($permit = Permit::findByKey('settings.translations')) {
            $permit->key = 'admin.options.translations';
            $permit->save();
        }

        // Correggo le voci di traduzione e aggiungo quelle mancanti
        Translation::putTranslation('permit_ns_admin.options', 'Ozioni', 'admin', 'it_IT');
        Translation::putTranslation('permit_admin.options', 'Può amministrare le opzioni', 'admin', 'it_IT');
        Translation::changeKey('permit_settings.translations', 'permit_admin.options.translations');

        // Aggiungo il permesso per l'amministrazione dei template delle notifiche per tutti i ruoli di amministrazione
        $permits = [
            'admin.options.notifications' => 'Può amministrare i template delle notifiche',
        ];

        /** @var Role[] $roles */
        $roles = Role::all(
            [
                'select'     => '`from`.*',
                'joins'      => 'INNER JOIN ' . PermitRole::tableName() . ' AS pr ON pr.role_id = `from`.id'
                                . ' INNER JOIN ' . Permit::tableName() . ' AS p ON p.id = pr.permit_id',
                'conditions' => [
                    'p.key = :admin_permit',
                    'admin_permit' => 'admin',
                ],
            ]
        );

        foreach ($permits as $key => $translation) {
            $permit = Permit::findByKey($key);

            if (!$permit) {
                $permit = Permit::create(
                    [
                        'key'        => $key,
                        'is_enabled' => true,
                    ]
                );
            }

            foreach ($roles as $role) {
                $pr = PermitRole::find($permit->id, $role->id);

                if (!$pr) {
                    PermitRole::create(
                        [
                            'permit_id' => $permit->id,
                            'role_id'   => $role->id,
                        ]
                    );
                }
            }

            Translation::putTranslation('permit_' . $key, $translation, 'core', 'it_IT');
        }
    }
}
