<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Updates;

use Application\Core\Model\Province;
use Updates\BaseUpdate;

class Update1 extends BaseUpdate
{
    /**
     * {@inheritdoc}
     */
    public function commit()
    {
        $province = Province::first([
            'conditions' => ['name = :name', 'name' => 'Forlì'],
        ]);

        if ($province !== null) {
            $province->name = 'Forlì-Cesena';
            $province->save();
        }
    }

    /**
     * {@inheritdoc}
     */
    public function rollback(\Exception $prev)
    {
        $province = Province::first([
            'conditions' => ['name = :name', 'name' => 'Forlì-Cesena'],
        ]);

        if ($province !== null) {
            $province->name = 'Forlì';
            $province->save();
        }
    }
}
