<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Tests\Utilities;

use Application\Core\Utilities\Validator;

/**
 * @covers \Application\Core\Utilities\Validator
 */
final class ValidatorTest extends \PHPUnit\Framework\TestCase
{
    public function testCodiceFiscale(): void
    {
        // codici fiscali corretti
        $this->assertTrue(Validator::codice_fiscale(''));
        $this->assertTrue(Validator::codice_fiscale('MROrSs00a00A000U'));

        // codice fiscale anomalo
        $this->assertTrue(Validator::codice_fiscale('sntrrt63e08h50ml'));

        // codici fiscali sbagliati
        $this->assertFalse(Validator::codice_fiscale('xxx'));
        $this->assertFalse(Validator::codice_fiscale('MRORSS00A00A000V'));
        $this->assertFalse(Validator::codice_fiscale('MRORSS00A+0A000V'));

        // il codice fiscale di un’azienda segue le regole della partita iva
        $this->assertTrue(Validator::codice_fiscale('00000000000'));
        $this->assertTrue(Validator::codice_fiscale('44444444440'));
        $this->assertTrue(Validator::codice_fiscale('12345678903'));
    }

    public function testPartitaIva(): void
    {
        $this->assertTrue(Validator::partita_iva(''));
        $this->assertTrue(Validator::partita_iva('00000000000'));
        $this->assertTrue(Validator::partita_iva('44444444440'));
        $this->assertTrue(Validator::partita_iva('12345678903'));

        $this->assertFalse(Validator::partita_iva('123'));
        $this->assertFalse(Validator::partita_iva('00000+00000'));
        $this->assertFalse(Validator::partita_iva('xxxxxxxxxxxx'));
        $this->assertFalse(Validator::partita_iva('123456789012'));
        $this->assertFalse(Validator::partita_iva('00000000001'));
    }

    public function testIban(): void
    {
        $this->assertTrue(Validator::iban(''));
    }

    public function testSdi(): void
    {
        $this->assertTrue(Validator::sdi(''));
    }
}
