<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Mailer {
    if (!function_exists('Application\\Core\\Mailer\\absolute_url')) {
        function absolute_url(string $url): string
        {
            return $url;
        }
    }
}

namespace Application\Core\Tests\Utilities {
    use Application\Core\Model\Account;
    use Application\Core\Utilities\UserActivationLinkBuilder;
    use PHPUnit\Framework\MockObject\MockObject;

    class UserActivationLinkBuilderTest extends \PHPUnit\Framework\TestCase
    {
        public function testBuilder(): void
        {
            $builder = new UserActivationLinkBuilder();

            $account = $this->getAccountMock();
            $account->expects($this->any())->method('resetActivationKey')->willReturn($account);
            $account->expects($this->any())->method('save')->willReturn(true); // @todo AccountManager
            $account->expects($this->any())->method('getId')->willReturn(123);
            $account->expects($this->any())->method('getActivationKey')->willReturn('abc123def456');

            /**
             * @var \Application\Core\Entity\AccountInterface $account
             */

            $this->assertEquals('/user/activation/?u=123&amp;key=abc123def456', $builder->build($account));
        }

        protected function getAccountMock(): Account|MockObject
        {
            return $this->createMock(Account::class);
        }
    }
}
