<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author Daniele Termini
 * @package Application\Core
 */

namespace Application\Core\Tests\Utilities\Link\Utilities;

use Application\Core\Entity\LinkTypeInterface;
use Application\Core\LinkType\LinkHandlerInterface;
use Application\Core\Model\Manager\LinkTypeManagerInterface;

class Mocks
{
    /**
     * @var \PHPUnit\Framework\TestCase
     */
    protected $test;

    public function __construct(\PHPUnit\Framework\TestCase $test)
    {
        $this->test = $test;
    }

    /**
     * @return LinkTypeInterface|\PHPUnit\Framework\MockObject\MockObject
     */
    public function getLinkTypeMock()
    {
        return $this->test->getMockBuilder(\Application\Core\Entity\LinkTypeInterface::class)->getMock();
    }

    /**
     * @return LinkHandlerInterface|\PHPUnit\Framework\MockObject\MockObject
     */
    public function getLinkHandlerMock()
    {
        return $this->test->getMockBuilder(\Application\Core\LinkType\LinkHandlerInterface::class)->getMock();
    }

    /**
     * @return LinkTypeManagerInterface|\PHPUnit\Framework\MockObject\MockObject
     */
    public function getLinkTypeManagerMock()
    {
        return $this->test->getMockBuilder(\Application\Core\Model\Manager\LinkTypeManagerInterface::class)->getMock();
    }
}
