<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Tests\Model;

use Application\Core\Model\BannedEmailMatcher;

final class BannedEmailMatcherTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var BannedEmailMatcher
     */
    private $matcher;

    protected function setUp(): void
    {
        $this->matcher = new BannedEmailMatcher();
    }

    public function testStrictMatch(): void
    {
        $this->assertTrue(
            $this->matcher->match(
                'info@example.com',
                BannedEmailMatcher::STRICT_MATCH,
                'info@example.com'
            )
        );
    }

    public function testStrictNotMatch(): void
    {
        $this->assertFalse(
            $this->matcher->match(
                'info@example.it',
                BannedEmailMatcher::STRICT_MATCH,
                'info@example.com'
            )
        );
    }

    public function testRegexMatch(): void
    {
        $this->assertTrue(
            $this->matcher->match(
                'info@example.com',
                BannedEmailMatcher::REGEX_MATCH,
                '@example.com'
            )
        );
    }

    public function testRegexNotMatch(): void
    {
        $this->assertFalse(
            $this->matcher->match(
                'info@example.it',
                BannedEmailMatcher::REGEX_MATCH,
                '@example.com'
            )
        );
    }
}
