<?php

namespace Application\Core\Tests\Form\Field;

use Application\Core\Form\Field\PermitsCheckListNamespaceCompiler;

class PermitsCheckListTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @dataProvider compileProvider
     */
    public function testCompile($keys, $expected): void
    {
        $compiler = new PermitsCheckListNamespaceCompiler($keys);

        $this->assertEquals($expected, $compiler->compile());
    }

    public function compileProvider()
    {
        return [
            [
                [],
                [],
            ],
            [
                [
                    'foo',
                ],
                [
                    'foo' => [
                        'permits' => [
                            'foo',
                        ],
                    ],
                ],
            ],
            [
                [
                    'foo',
                    'bar',
                ],
                [
                    'foo' => [
                        'permits' => [
                            'foo',
                        ],
                    ],
                    'bar' => [
                        'permits' => [
                            'bar',
                        ],
                    ],
                ],
            ],
            [
                [
                    'foo.bar',
                    'foo',
                ],
                [
                    'foo' => [
                        'permits' => [
                            'foo.bar',
                            'foo',
                        ],
                    ],
                ],
            ],
            [
                [
                    'foo',
                    'foo.bar',
                    'foo.bar.baz',
                ],
                [
                    'foo' => [
                        'permits'  => [
                            'foo',
                        ],
                        'fieldset' => [
                            'foo.bar' => [
                                'permits' => [
                                    'foo.bar',
                                    'foo.bar.baz',
                                ],
                            ],
                        ],
                    ],
                ],
            ],
            [
                [
                    'admin',
                    'blog.admin',
                    'blog.add',
                    'blog.edit',
                    'blog.delete',
                    'blog.category.admin',
                    'blog.category.add',
                    'blog.category.edit',
                    'blog.category.delete',
                    'blog.tag.admin',
                    'blog.tag.add',
                    'blog.tag.edit',
                    'blog.tag.delete',
                ],
                [
                    'admin' => [
                        'permits' => ['admin'],
                    ],
                    'blog'  => [
                        'permits'  => [
                            'blog.admin',
                            'blog.add',
                            'blog.edit',
                            'blog.delete',
                        ],
                        'fieldset' => [
                            'blog.category' => [
                                'permits' => [
                                    'blog.category.admin',
                                    'blog.category.add',
                                    'blog.category.edit',
                                    'blog.category.delete',
                                ],
                            ],
                            'blog.tag'      => [
                                'permits' => [
                                    'blog.tag.admin',
                                    'blog.tag.add',
                                    'blog.tag.edit',
                                    'blog.tag.delete',
                                ],
                            ],
                        ],
                    ],
                ],
            ],
            [
                [
                    'baz',
                    'foo',
                    'foo.bar',
                    'foo.baz',
                    'bar',
                    'bar.foo',
                    'bar.bar',
                    'bar.bar.foo',
                ],
                [
                    'baz' => [
                        'permits' => [
                            'baz',
                        ],
                    ],
                    'foo' => [
                        'permits' => [
                            'foo',
                            'foo.bar',
                            'foo.baz',
                        ],
                    ],
                    'bar' => [
                        'permits'  => [
                            'bar',
                            'bar.foo',
                        ],
                        'fieldset' => [
                            'bar.bar' => [
                                'permits' => [
                                    'bar.bar',
                                    'bar.bar.foo',
                                ],
                            ],
                        ],
                    ],
                ],
            ],
        ];
    }
}
