<?php

/**
 * Questo file è parte di Pongho 2.0.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   ???
 */

namespace Application\Core\Tests\Form\Field;

use Application\Core\Form\Field\GeoField;
use Symfony\Component\DomCrawler\Crawler;

class GeoFieldTest extends \PHPUnit\Framework\TestCase
{
    public function testValue(): void
    {
        $input = new GeoField('geo');

        $this->assertEquals($input->emptyValue(), $input->getValue());
    }

    public function testTagRender(): void
    {
        $input = new GeoField('geo');
        $input->setValue([['lat' => '123', 'lng' => '321']]);

        $code = $input->render();

        $crawler = new Crawler($code);

        $wrapper = $crawler->filter('div.geo-localization');
        $this->assertCount(1, $wrapper);
        $this->assertEquals('geo', $wrapper->attr('data-field-name'));

        $address = $wrapper->filter('address');
        $this->assertCount(1, $address);
        $this->assertEquals('123', $address->attr('data-lat'));
        $this->assertEquals('321', $address->attr('data-lng'));
    }
}
