<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Tests\Db\Maintainer;

use Application\Core\Db\Maintainer\TaskInterface;
use Application\Core\Db\Maintainer\TaskList;
use PHPUnit\Framework\MockObject\MockObject;

final class TaskListTest extends \PHPUnit\Framework\TestCase
{
    public function testCountable(): void
    {
        $taskList = new TaskList();
        $this->assertInstanceOf(\Countable::class, $taskList);
        $this->assertEquals(0, count($taskList));

        $taskList->registerTask($this->getTaskMock());
        $taskList->registerTask($this->getTaskMock());
        $taskList->registerTask($this->getTaskMock());
        $this->assertEquals(3, count($taskList));
    }

    public function testTraversable(): void
    {
        $taskList = new TaskList();
        $this->assertInstanceOf(\Traversable::class, $taskList);

        $taskList->registerTask($this->getTaskMock());
        $taskList->registerTask($this->getTaskMock());
        $taskList->registerTask($this->getTaskMock());

        $i = 0;
        foreach ($taskList as $task) {
            $this->assertInstanceOf(TaskInterface::class, $task);
            $i++;
        }

        $this->assertEquals(3, $i);
    }

    public function testExecuteCallsAllTasks(): void
    {
        $taskList = new TaskList();
        $taskList->registerTask($this->getExecutableTaskMock());
        $taskList->registerTask($this->getExecutableTaskMock());
        $taskList->registerTask($this->getExecutableTaskMock());

        $taskList->execute();
    }

    private function getTaskMock(): TaskInterface|MockObject
    {
        return $this->createMock(TaskInterface::class);
    }

    private function getExecutableTaskMock(): TaskInterface|MockObject
    {
        $task = $this->createMock(TaskInterface::class);

        $task->expects($this->once())->method('execute');

        return $task;
    }
}
