<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Tests\Console\Command;

use Application\Core\Console\Command\DbClearCommand;
use Application\Core\Db\Maintainer\TaskInterface;
use Application\Core\Db\Maintainer\TaskList;
use PHPUnit\Framework\MockObject\MockObject;
use Symfony\Component\Console\Application;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\StreamOutput;

final class DbClearCommandTest extends \PHPUnit\Framework\TestCase
{
    public function testExecute(): void
    {
        $taskList = new TaskList();
        $taskList->registerTask($this->getExecutableTaskMock());
        $taskList->registerTask($this->getExecutableTaskMock());
        $taskList->registerTask($this->getExecutableTaskMock());

        $application = new Application();
        $application->add(new DbClearCommand($taskList));

        $command = $application->find('db:clear');

        $input = new ArrayInput([
            'command' => $command->getName(),
        ]);

        $output = new StreamOutput(fopen('php://memory', 'r+', false));

        $command->run($input, $output);
    }

    private function getExecutableTaskMock(): TaskInterface|MockObject
    {
        $task = $this->createMock(TaskInterface::class);

        $task->expects($this->once())->method('execute');

        return $task;
    }
}
