<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Test;

use Pongho\Core\Kernel;
use Pongho\Http\Request as PonghoRequest;
use Pongho\Http\Response as PonghoResponse;
use Symfony\Component\BrowserKit\Client as BrowserKitClient;
use Symfony\Component\BrowserKit\CookieJar;
use Symfony\Component\BrowserKit\History;
use Symfony\Component\BrowserKit\Request as BrowserKitRequest;
use Symfony\Component\BrowserKit\Response as BrowserKitResponse;

final class Client extends BrowserKitClient
{
    /**
     * @var Kernel
     */
    private $kernel;

    public function __construct(
        Kernel $kernel,
        array $server = [],
        ?History $history = null,
        ?CookieJar $cookieJar = null
    ) {
        $this->kernel = $kernel;

        parent::__construct($server, $history, $cookieJar);
    }

    /**
     * @param PonghoRequest $request
     * @return PonghoResponse
     */
    protected function doRequest($request)
    {
        return $this->kernel->handle($request);
    }

    /**
     * @return PonghoRequest
     */
    protected function filterRequest(BrowserKitRequest $request)
    {
        return PonghoRequest::create(
            $request->getUri(),
            $request->getMethod(),
            $request->getParameters(),
            $request->getCookies(),
            $request->getFiles(),
            $request->getServer(),
            $request->getContent()
        );
    }

    /**
     * @param PonghoResponse $response
     * @return BrowserKitResponse
     */
    protected function filterResponse($response)
    {
        return new BrowserKitResponse(
            $response->getContent(),
            $response->getStatusCode(),
            $response->getHeaders()->all()
        );
    }
}
