<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Routes;

use Application\Core\Model\Account;
use Pongho\Http\RedirectResponse;
use Pongho\Http\Request;
use Pongho\Routing\RouteInterface;

class UserViewRoute implements RouteInterface
{
    /**
     * @var \Application\Core\Model\Account
     */
    protected $account;

    /**
     * @var string
     */
    protected $path;

    /**
     * @var string
     */
    protected $action = 'view';

    /**
     * @var array
     */
    protected $options = [
        '_controller' => \Application\Core\Controller\UserController::class,
    ];

    /**
     * @param string $path
     */
    public function __construct($path = '/user/view', array $options = [])
    {
        $this->path = '/' . trim($path, '/');

        $this->options = array_merge($this->options, $options);
    }

    /**
     * @return string
     */
    public function getPath()
    {
        return $this->path;
    }

    /**
     * {@inheritdoc}
     */
    public function match(Request $request)
    {
        if (str_starts_with($request->getPathInfo(), $this->path)) {
            $path = substr($request->getPathInfo(), strlen($this->path));

            $segments = explode('/', trim($path, '/'));

            if (($url = array_shift($segments)) === null) {
                return false;
            }

            if (isset($segments[0])) {
                $this->action = $segments[0];
            }

            /** @var Account $account */
            $account = Account::first([
                'conditions' => ['old_url = ?', $url],
            ]);

            if ($account) {
                return new RedirectResponse($this->path . '/' . $account->url . '/');
            }

            /** @var Account $account */
            $account = Account::first([
                'conditions' => ['url = ?', $url],
            ]);

            if ($account === null) {
                return false;
            }

            $this->account = $account;

            return true;
        }

        return false;
    }

    /**
     * {@inheritdoc}
     */
    public function getController()
    {
        return $this->options['_controller'];
    }

    /**
     * {@inheritdoc}
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * {@inheritdoc}
     */
    public function getParameters()
    {
        return [
            'account' => $this->account,
        ];
    }
}
