<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele De Nobili
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Routes;

use Application\Core\Model\LanguageModule;
use Application\Core\Model\Module;
use Pongho\Core\Kernel;
use Pongho\Http\Request;
use Pongho\Routing\RouteInterface;

class ModulesRoute implements RouteInterface
{
    /**
     * @var \Application\Core\Model\ModuleSite
     */
    protected $moduleSite;

    /**
     * @var \Application\Core\Model\LanguageSite
     */
    protected $languageSite;

    /**
     * @var string
     */
    protected $action = 'index';

    /**
     * @var int
     */
    protected $id;

    /**
     * {@inheritdoc}
     */
    public function match(Request $request)
    {
        /** @var \Application\Core\Model\Site $site */
        $site = Kernel::instance()->getContainer()->get('site');

        foreach ($site->getLanguagesModules() as $languageModule) {
            if ($request->getPathInfo() == $languageModule->path) {
                $this->moduleSite = $languageModule->getModuleSite();
                $this->languageSite = $languageModule->getLanguageSite();
                $this->action = 'index';

                $this->fixAppBCBreak($languageModule);

                break;
            }
        }

        if ($this->moduleSite !== null) {
            return true;
        }

        foreach ($site->getLanguagesModules() as $languageModule) {
            if (str_starts_with($request->getPathInfo(), $languageModule->path)) {
                $this->moduleSite = $languageModule->getModuleSite();
                $this->languageSite = $languageModule->getLanguageSite();

                $segments = explode('/', substr($request->getPathInfo(), strlen($languageModule->path)));

                if (isset($segments[0])) {
                    $this->action = $segments[0];

                    if (isset($segments[1])) {
                        $this->id = $segments[1];
                    }
                }

                $this->fixAppBCBreak($languageModule);

                break;
            }
        }

        return $this->moduleSite !== null;
    }

    /**
     * {@inheritdoc}
     */
    public function getController()
    {
        return $this->moduleSite->getModule()->getController();
    }

    /**
     * {@inheritdoc}
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * {@inheritdoc}
     */
    public function getParameters()
    {
        return [
            'site_module'   => $this->moduleSite,
            'site_language' => $this->languageSite,
            'id'            => $this->id,
        ];
    }

    /**
     * Corregge una bc-break con le app.
     *
     * Alcune app richiedono erroneamente 'name', 'path' e 'node_type' al moduleSite.
     * Bisogna correggere le app ed eliminare questo metodo.
     *
     * @todo: Correggere le app e rimuovere questo metodo.
     */
    private function fixAppBCBreak(LanguageModule $languageModule)
    {
        $this->moduleSite->name = $languageModule->name;
        $this->moduleSite->path = $languageModule->path;

        /**
         * Il "@var" qua sotto aiuta Rector a capire meglio il codice
         *
         * @link https://github.com/rectorphp/rector/issues/9264
         *
         * @var Module $module
         */
        $module = $this->moduleSite->getModule();
        if (isset($module->node_type)) {
            $this->moduleSite->node_type = $module->node_type;
        }
    }
}
