<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Routes;

use Pongho\Http\Request;
use Pongho\Routing\RouteInterface;

class ImagesRoute implements RouteInterface
{
    /**
     * @var string
     */
    private $image_path;

    /**
     * {@inheritdoc}
     */
    public function match(Request $request)
    {
        if (str_starts_with($request->getPathInfo(), '/content/images')) {
            $this->image_path = substr($request->getPathInfo(), 15); // rimuovo il pezzo '/content/images', 15 caratteri

            return true;
        }

        return false;
    }

    /**
     * {@inheritdoc}
     */
    public function getController()
    {
        return \Application\Core\Controller\ImagesController::class;
    }

    /**
     * {@inheritdoc}
     */
    public function getAction()
    {
        return 'display';
    }

    /**
     * {@inheritdoc}
     */
    public function getParameters()
    {
        return [
            'image_path' => $this->image_path,
        ];
    }
}
