<?php

/**
 * @var \Application\Core\Utilities\Html $html
 * @var \Application\Core\Model\Site     $site
 * @var string                           $action_form
 * @var string                           $value_fb
 * @var string                           $value_fb_comments
 * @var string                           $value_fb_appid
 * @var string                           $value_fb_appsecret
 * @var string                           $value_fb_admin_id
 * @var string                           $value_fb_og_type
 * @var string                           $value_linkedin_client_id
 * @var string                           $value_linkedin_client_secret
 */

?>
<form action="<?= $action_form ?>" method="post" class="section">

    <h2>Opzioni</h2>

    <?php include 'messages.php'; ?>
    <?php include 'tabs.php'; ?>

    <div class="tabsPanel" id="panel-social">
        <fieldset class="panel">
            <h3>Facebook</h3>
            <dl class="extend">
                <dt><label for="field-fb">Abilita API</label></dt>
                <dd>
                    <input type="checkbox" name="options[fb]" id="field-fb"<?= $value_fb ? ' checked="checked"' : '' ?>>
                    <span>Attiva le API Facebook</span>
                </dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-fb-comments">Commenti Facebook</label></dt>
                <dd>
                    <input type="checkbox" name="options[fb_comments]" id="field-fb-comments"<?= $value_fb_comments ? ' checked="checked"' : '' ?>>
                    <span>Attiva i commenti di Facebook</span>
                </dd>
                <dd>
                    <a href="https://developers.facebook.com/tools/comments?id=FB_APPID" target="_blank">Moderazione Commenti</a>
                    - <a href="https://graph.facebook.com/comments/?ids=XID" target="_blank">Graph Commenti</a>
                </dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-fb-appid">Facebook AppID</label></dt>
                <dd><input type="text" name="options[fb_appid]" id="field-fb-appid" value="<?= $value_fb_appid ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-fb-appsecret">Facebook AppSecret</label></dt>
                <dd><input type="text" name="options[fb_appsecret]" id="field-fb-appsecret" value="<?= $value_fb_appsecret ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-fb-admin-id">Facebook Admin ID</label></dt>
                <dd>
                    <input type="text" name="options[fb_admin_id]" id="field-fb-admin-id" value="<?= $value_fb_admin_id ?>" class="input_text"/>
                    <span>ID separati da virgola, senza spazio.</span>
                </dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-fb-og-type">Tipologia del sito</label></dt>
                <dd>
                    <input type="text" name="options[fb_og_type]" id="field-fb-og-type" value="<?= $value_fb_og_type ?>" class="input_text"/>
                    <a href="http://developers.facebook.com/docs/opengraph/#types" target="_blank">Documentazione</a>
                </dd>
            </dl>
        </fieldset>
		<fieldset class="panel">
			<h3>Sign in with LinkedIn</h3>
			<ul style="margin: 0 0 1.5rem 1.5rem;">
				<li><a href="https://www.linkedin.com/developers/apps/new">Crea un app su LinkedIn</a></li>
				<li>Inserisci questa callback: <code><?= absolute_url('/user/linkedin-callback/'); ?></code></li>
				<li>Attiva il prodotto "Sign in with LinkedIn"</li>
				<li>Riporta qua sotto le credenziali di autenticazione</li>
				<li>Inserisci il link per accedere con LinkedIn: <code>&lt;?= get_linkedin_auth_url(); ?&gt;</code></li>
			</ul>
			<dl class="extend">
				<dt><label for="field-linkedin_client_id">Client ID</label></dt>
				<dd>
					<input type="text" name="options[linkedin_client_id]" id="field-linkedin_client_id" value="<?= $value_linkedin_client_id; ?>" class="input_text">
				</dd>
			</dl>
			<dl class="extend">
				<dt><label for="field-linkedin_client_secret">Client Secret</label></dt>
				<dd>
					<input type="text" name="options[linkedin_client_secret]" id="field-linkedin_client_secret" value="<?= $value_linkedin_client_secret; ?>" class="input_text">
				</dd>
			</dl>
		</fieldset>
    </div>

    <fieldset class="btn">
        <input type="submit" value="Salva" class="primary"/>
    </fieldset>

</form><!-- .section -->
