<?php

/**
 * @var \Application\Core\I18n\Translation\Translator $translator
 * @var string                                        $action_form
 * @var string                                        $value_gapi_view_id
 */

?>
<form action="<?= $action_form ?>" method="post" class="section">

    <h2>Opzioni</h2>

    <?php include 'messages.php'; ?>
    <?php include 'tabs.php'; ?>

    <div class="tabsPanel" id="panel-dashboard">
        <fieldset class="panel">
            <h3 style="margin-bottom: 8px;"><?= $translator->trans('Google Analytics API'); ?></h3>
            <p style="margin-bottom: 16px; padding: 0;">
                <?= $translator->trans('Le Api di Google Analytics vengono utilizzate in bacheca per visualizzare le statistiche principali del sito. Al momento è possibile utilizzare solo account Analytics collegati alla mail “webagencymetaline@gmail.com”. Per il funzionamento, è necessario indicare l’ID della vista di Analytics del sito. Per conoscerla, è necessario accedere a Google Analytics, cliccare su “Amministrazione” in basso a sinistra, selezionare in ordine l’account, la proprietà e quindi la vista, cliccare su “Impostazioni vista” e copiare il valore del campo “ID vista”.') ?>
            </p>

            <dl class="extend">
                <dt><label for="field-gapi-view-id"><?= $translator->trans('View ID'); ?></label></dt>
                <dd><input type="text" name="options[gapi_view_id]" id="field-gapi-view-id" value="<?= $value_gapi_view_id ?>" class="input_text"/></dd>
            </dl>
        </fieldset>
    </div>

    <fieldset class="btn">
        <input type="submit" value="<?= $lang->get('save'); ?>" class="primary"/>
    </fieldset>

</form><!-- .section -->
