<?php

/**
 * @var \Application\Core\Utilities\Html $html
 * @var \Application\Core\Model\Site     $site
 * @var string                           $action_form
 * @var string                           $value_company_name
 * @var string                           $value_company_type
 * @var string                           $value_company_ceo_name
 * @var string                           $value_company_address
 * @var string                           $value_company_postcode
 * @var string                           $value_company_city
 * @var string                           $value_company_province
 * @var string                           $value_company_province_plate
 * @var string                           $value_company_country
 * @var string                           $value_company_partita_iva
 * @var string                           $value_company_codice_fiscale
 * @var string                           $value_company_rea
 * @var string                           $value_company_camera
 * @var string                           $value_company_cap_soc
 * @var string                           $value_company_website
 * @var string                           $value_company_email
 * @var string                           $value_company_tel
 * @var string                           $value_company_tel2
 * @var string                           $value_company_tel3
 * @var string                           $value_company_fax
 * @var string                           $value_company_fax2
 * @var string                           $value_company_fax3
 * @var string                           $value_company_latitude
 * @var string                           $value_company_longitude
 * @var string                           $value_company_copyright
 */

?>
<form action="<?= $action_form ?>" method="post" class="section">

    <h2>Opzioni</h2>

    <?php include 'messages.php'; ?>
    <?php include 'tabs.php'; ?>

    <div class="tabsPanel" id="panel-company">
        <fieldset class="panel">
            <h3>Dati aziendali</h3>
            <dl class="extend">
                <dt><label for="field-company-name">Ragione sociale</label></dt>
                <dd><input type="text" name="options[company_name]" id="field-company-name" value="<?= $value_company_name ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-type">Tipologia azienda</label></dt>
                <dd><input type="text" name="options[company_type]" id="field-company-type" value="<?= $value_company_type ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-ceo-name">Legale rappresentante</label></dt>
                <dd><input type="text" name="options[company_ceo_name]" id="field-company-ceo-name" value="<?= $value_company_ceo_name ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-address">Indirizzo</label></dt>
                <dd><input type="text" name="options[company_address]" id="field-company-address" value="<?= $value_company_address ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-postcode">CAP</label></dt>
                <dd><input type="text" name="options[company_postcode]" id="field-company-postcode" value="<?= $value_company_postcode ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-city">Città</label></dt>
                <dd><input type="text" name="options[company_city]" id="field-company-city"
                           value="<?= $value_company_city ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-province">Provincia</label></dt>
                <dd><input type="text" name="options[company_province]" id="field-company-province" value="<?= $value_company_province ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-province-plate">Sigla provincia</label></dt>
                <dd><input type="text" name="options[company_province_plate]" id="field-company-province-plate" value="<?= $value_company_province_plate ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-country">Paese</label></dt>
                <dd><input type="text" name="options[company_country]" id="field-company-country" value="<?= $value_company_country ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-partita-iva">Partita IVA</label></dt>
                <dd><input type="text" name="options[company_partita_iva]" id="field-company-partita-iva" value="<?= $value_company_partita_iva ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-codice-fiscale">Codice Fiscale</label></dt>
                <dd><input type="text" name="options[company_codice_fiscale]" id="field-company-codice-fiscale" value="<?= $value_company_codice_fiscale ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-rea">R.E.A.</label></dt>
                <dd><input type="text" name="options[company_rea]" id="field-company-rea" value="<?= $value_company_rea ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-camera">Camera di commercio</label></dt>
                <dd><input type="text" name="options[company_camera]" id="field-company-camera" value="<?= $value_company_camera ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-cap-soc">Capitale Sociale</label></dt>
                <dd><input type="text" name="options[company_cap_soc]" id="field-company-cap-soc" value="<?= $value_company_cap_soc ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-website">Sito web</label></dt>
                <dd><input type="text" name="options[company_website]" id="field-company-website" value="<?= $value_company_website ?>" class="input_text"/></dd>
            </dl>
        </fieldset>

        <fieldset class="panel">
            <h3>Contatti</h3>

            <dl class="extend">
                <dt><label for="field-company-email">Indirizzo E-mail</label></dt>
                <dd><input type="text" name="options[company_email]" id="field-company-email" value="<?= $value_company_email ?>" class="input_text"<?= isset($config_dev['company_email']) ? ' readonly' : ''; ?>></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-tel">Telefono 1</label></dt>
                <dd><input type="text" name="options[company_tel]" id="field-company-tel" value="<?= $value_company_tel ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-tel2">Telefono 2</label></dt>
                <dd><input type="text" name="options[company_tel2]" id="field-company-tel2" value="<?= $value_company_tel2 ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-tel3">Telefono 3</label></dt>
                <dd><input type="text" name="options[company_tel3]" id="field-company-tel3" value="<?= $value_company_tel3 ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-fax">Fax 1</label></dt>
                <dd><input type="text" name="options[company_fax]" id="field-company-fax" value="<?= $value_company_fax ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-fax2">Fax 2</label></dt>
                <dd><input type="text" name="options[company_fax2]" id="field-company-fax2" value="<?= $value_company_fax2 ?>" class="input_text"/></dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-fax3">Fax 3</label></dt>
                <dd><input type="text" name="options[company_fax3]" id="field-company-fax3" value="<?= $value_company_fax3 ?>" class="input_text"/></dd>
            </dl>
        </fieldset>

        <fieldset class="panel">
            <h3>Google Maps</h3>

            <dl class="extend">
                <dt><label for="field-company-latitude">Latitudine</label></dt>
                <dd>
                    <input type="text" name="options[company_latitude]" id="field-company-latitude" value="<?= $value_company_latitude ?>" class="input_text"/>
                    <a href="http://www.doogal.co.uk/LatLong.php" target="_blank">Documentazione</a>
                </dd>
            </dl>

            <dl class="extend">
                <dt><label for="field-company-longitude">Longitudine</label></dt>
                <dd><input type="text" name="options[company_longitude]" id="field-company-longitude" value="<?= $value_company_longitude ?>" class="input_text"/></dd>
            </dl>
        </fieldset>

        <fieldset class="panel">
            <h3>Copyright</h3>

            <dl class="extend">
                <dt><label for="field-company-copyright">Copyright</label></dt>
                <dd><input type="text" name="options[company_copyright]" id="field-company-copyright" value="<?= $value_company_copyright ?>" class="input_text"/></dd>
            </dl>
        </fieldset>
    </div>

    <fieldset class="btn">
        <input type="submit" value="Salva" class="primary"/>
    </fieldset>

</form><!-- .section -->
