<?php

/**
 * @var string $action_form
 * @var \Application\Core\Model\Language[] $rows
 */

?>
<form action="<?= $action_form ?>" method="post" class="section">

	<h2>Gestione lingue</h2>

	<?php include 'messages.php'; ?>
	<?php include 'tabs.php'; ?>

	<fieldset class="panel">
		<p>Tutte le lingue installate in Pongho. Per abilitare una lingua su un sito passare alla tab “Lingue abilitate”.</p>

		<table class="pongho-table">
			<thead>
				<tr>
					<th class="main">Nome</th>
					<th class="main">ISO</th>
					<th class="main">Culture</th>
					<th class="main">Locale</th>
					<th class="main">Timezone</th>
				</tr>
			</thead>
			<tfoot>
				<tr>
					<th class="main">Nome</th>
					<th class="main">ISO</th>
					<th class="main">Culture</th>
					<th class="main">Locale</th>
					<th class="main">Timezone</th>
				</tr>
			</tfoot>

			<tbody>
				<?php foreach ($rows as $row): ?>
					<tr>
						<td>
							<img class="flag" src="<?= pongho_url("/Application/Core/Resources/flags/16/{$row->culture}.png"); ?>" alt="<?= $row->iso; ?>" title="<?= $row->name; ?>">
							<input type="hidden" name="languages[<?= $row->id ?>][name]" value="<?= $row->name ?>" />
							<?= $row->name ?>
						</td>
						<td><input type="hidden" name="languages[<?= $row->id ?>][iso]" value="<?= $row->iso ?>" class="input_text" style="width: 150px;"><?= $row->iso ?></td>
						<td><input type="text" name="languages[<?= $row->id ?>][culture]" value="<?= $row->culture ?>" class="input_text" style="width: 150px;"></td>
						<td><input type="text" name="languages[<?= $row->id ?>][locale]" value="<?= $row->locale ?>" class="input_text" style="width: 150px;"></td>
						<td><input type="text" name="languages[<?= $row->id ?>][timezone]" value="<?= $row->timezone ?>" class="input_text" style="width: 150px;"></td>
					</tr>
				<?php endforeach; ?>

				<tr class="clonable">
					<td><input type="text" name="languages[new][name]" value="" class="input_text" style="width: 150px;"></td>
					<td><input type="text" name="languages[new][iso]" value="" class="input_text" style="width: 150px;"></td>
					<td><input type="text" name="languages[new][culture]" value="" class="input_text" style="width: 150px;"></td>
					<td><input type="text" name="languages[new][locale]" value="" class="input_text" style="width: 150px;"></td>
					<td><input type="text" name="languages[new][timezone]" value="" class="input_text" style="width: 150px;"></td>
				</tr>
			</tbody>
		</table>
	</fieldset><!-- .panel -->

	<fieldset class="btn">
		<input type="submit" value="Salva" class="primary" />
	</fieldset>

</form><!-- .section -->
