/*jslint nomen: true, plusplus: true, passfail: true, browser: true, devel: true */
/*global $, jQuery */

$(document).ready(function () {
    "use strict";

    function manageAccountNotifications() {
        $('#field-user-is_active').manageAccountNotifications({
            action: Pongho.action,
            notifyEditSelector: '#field-user-notify_edit',
            notifyStatusSelector: '#field-user-notify_status',
            notifyCredentialsSelector: '#field-user-notify_credentials',
            notifyCreationSelector: '#field-user-notify_create',
            notifyLinkSelector: '#field-user-notify_activation_link'
        });
    }

    function onCreatePanel() {
        $('input[type="password"].pongho-field').managePassword();
        manageAccountNotifications();
    }

    if (Pongho.action !== 'add') {
        $('.form-wrapper').on('after-update', function () {
            onCreatePanel();
        });
    }

    onCreatePanel();

    $('.url-editor-btn').on('click', function () {
        var openBtn = $(this), url;

        openBtn.colorbox({
            'href'   : openBtn.data('form'),
            'width'  : 500,
            'height' : 400,
            'onComplete' : function () {
                var form = $('#account-url-form'),
                    input = $('#account-url'),
                    confirm = $('#account-url-confirm');

                form.on('click', 'button', function () {
                    var button = this,
                        data = form.serializeArray();

                    input.on('change', function () {
                        confirm.hide();
                    });

                    data.push({
                        'name': 'action',
                        'value': button.name
                    });

                    $.ajax({
                        'url': form.attr('action'),
                        'data': data,
                        'type': 'POST',
                        'success': function (response) {
                            var infoBox = $('#account-url-errors').empty();

                            if (response.error) {
                                infoBox.html('<div class="box error">' + response.message + '</div>');
                                return;
                            }

                            infoBox.html('<div class="box info">' + response.message + '</div>');

                            if (response.url) {
                                input.val(response.url);
                                confirm.show();
                            }

                            if (button.name === 'confirm') {
                                url = input.val();

                                $.colorbox.close();
                            }
                        }
                    });
                });

                form.on('submit', function (event) {
                    event.preventDefault();
                });
            },
            'onClosed': function () {
                if (url) {
                    $('.url-editor-slug').html(url);
                    openBtn.remove();
                }
            }
        });
    });
});
