/*jslint nomen: true, plusplus: true, passfail: true, browser: true, devel: true */
/*global $, jQuery */

function random(l) {
    var possible = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789', random = '', i;
    l = l || 8;

    for (i = 0; i < l; i++) {
        random += possible.charAt(Math.floor(Math.random() * possible.length));
    }

    return random;
}

$.fn.managePassword = function () {
    "use strict";

    var btn = $('<button />').attr('type', 'button').addClass('pongho-button').text('Random'),
        pwdField = $(this);

    btn
        .insertAfter(pwdField)
        .on('click', function () {
            pwdField.val(random(8));
        });
};

(function ($) {

    var defaults = {
        action: 'edit',
        notifyEditSelector: '#field-user-notify_edit',
        notifyStatusSelector: '#field-user-notify_status',
        notifyCredentialsSelector: '#field-user-notify_credentials',
        notifyCreationSelector: '#field-user-notify_create',
        notifyLinkSelector: '#field-user-notify_activation_link'
    };

    function Plugin(element, options) {
        this.element = $(element);
        this.options = $.extend({}, defaults, options);
        this.init();
    }

    Plugin.prototype = {
        init: function () {
            this.notifyEdit = $(this.options.notifyEditSelector);
            this.notifyStatus = $(this.options.notifyStatusSelector);
            this.notifyCredentials = $(this.options.notifyCredentialsSelector);
            this.notifyCreation = $(this.options.notifyCreationSelector);
            this.notifyLink = $(this.options.notifyLinkSelector);

            this.initialStatus = this.element.val();

            var self = this;

            this.element.on('change', function () {
                var status = self.element.val();

                if (self.options.action === 'add') {
                    if (status === 'active' || status === 'pending') {
                        self.notifyCreation.attr('disabled', false).prop('checked', true);
                    } else {
                        self.notifyCreation.attr('disabled', true).prop('checked', false);
                    }
                } else {
                    if (status === 'active') {
                        // Attivo le notifiche e suggerisco di inviare la notifica per il cambiamento dello stato
                        self.notifyLink.attr('disabled', true);
                        self.notifyEdit.attr('disabled', false);
                        self.notifyStatus.attr('disabled', self.initialStatus === status).prop('checked', self.initialStatus !== status);
                        self.notifyCredentials.attr('disabled', false);
                    } else if (status === 'pending') {
                        // Disattivo le notifiche non inviabili, attivo la notifica per la creazione (ce l'ho se sono in "add")
                        self.notifyLink.attr('disabled', false).prop('checked', false);
                        self.notifyEdit.attr('disabled', true).prop('checked', false);
                        self.notifyStatus.attr('disabled', true).prop('checked', false);
                        self.notifyCredentials.attr('disabled', true).prop('checked', false);
                    } else {
                        // Disattivo le notifiche non inviabili, attivo e suggerisco la notifica per il cambiamento dello stato
                        self.notifyLink.attr('disabled', true).prop('checked', false);
                        self.notifyEdit.attr('disabled', true).prop('checked', false);
                        self.notifyStatus.attr('disabled', self.initialStatus === status).prop('checked', self.initialStatus !== status);
                        self.notifyCredentials.attr('disabled', true).prop('checked', false);
                    }
                }
            });

            if (self.options.action === 'add') {
                self.notifyCreation.attr('disabled', false).prop('checked', true);
            } else {
                if (this.element.val() === 'active') {
                    // Rimuovo il campo dal DOM se sono passato da "add" a "edit"
                    self.notifyLink.closest('.control-group').remove();

                    // Attivo le notifiche e suggerisco di inviare la notifica per il cambiamento dello stato
                    self.notifyEdit.attr('disabled', false);
                    self.notifyStatus.attr('disabled', true);
                    self.notifyCredentials.attr('disabled', false);
                } else if (this.element.val() === 'pending') {
                    // Disattivo le notifiche non inviabili, attivo la notifica per la creazione (ce l'ho se sono in "add")
                    self.notifyLink.attr('disabled', false);
                    self.notifyEdit.attr('disabled', true);
                    self.notifyStatus.attr('disabled', true);
                    self.notifyCredentials.attr('disabled', true);
                } else {
                    // Rimuovo il campo dal DOM se sono passato da "add" a "edit"
                    self.notifyLink.remove();

                    // Disattivo le notifiche non inviabili, attivo e suggerisco la notifica per il cambiamento dello stato
                    self.notifyEdit.attr('disabled', true);
                    self.notifyStatus.attr('disabled', true);
                    self.notifyCredentials.attr('disabled', true);
                }
            }
        }
    };

    // A really lightweight plugin wrapper around the constructor,
    // preventing against multiple instantiations
    $.fn.manageAccountNotifications = function (options) {
        return this.each(function () {
            if (!$.data(this, "plugin_manageAccountNotifications")) {
                $.data(this, "plugin_manageAccountNotifications", new Plugin(this, options));
            }
        });
    };

})(jQuery);
