<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

/**
 * UserSubscribeAdminNotification
 *
 * Viene utilizzata all’iscrizione utente quando è richiesta l’approvazione da parte dell’amministratore.
 */
class UserSubscribeAdminNotification extends UserSubscribeNotification
{
    /**
     * {@inheritdoc}
     */
    public function getName(): string
    {
        return 'core.user_subscribe_admin';
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle(): string
    {
        return $this->translator->trans('User subscribe with admin approval');
    }
}
