<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

use Application\Core\Entity\LanguageInterface;

/**
 * UserActivatedNotification
 *
 * Viene inviata all’utente quando l’iscrizione deve essere accettata
 * dall'amministratore e viene spuntata la flag della notifica "Cambio stato".
 */
class UserActivatedNotification extends AbstractNotification
{
    use HasAccountTrait;
    use HasPasswordTrait;
    /**
     * {@inheritdoc}
     */
    public function getName(): string
    {
        return 'core.user_activated';
    }

    /**
     * {@inheritdoc}
     */
    public function getTitle(): string
    {
        return $this->translator->trans('User has been activated');
    }

    /**
     * {@inheritdoc}
     */
    public function getOptions(): NotificationOptions
    {
        if ($this->options === null) {
            $this->options = new NotificationOptions([
                'send_to_admin' => false,
                'send_to_user'  => true,
            ]);
        }

        return $this->options;
    }

    /**
     * {@inheritdoc}
     */
    public function getLanguage(): LanguageInterface
    {
        return $this->getAccount()->getLanguage();
    }

    /**
     * {@inheritdoc}
     */
    public function getVars(): array
    {
        $vars = parent::getVars();

        $vars[] = 'USER_USERNAME';
        $vars[] = 'USER_EMAIL';
        $vars[] = 'USER_FULL_NAME';
        $vars[] = 'USER_PASSWORD';
        $vars[] = 'USER_ROLE';

        return $vars;
    }

    /**
     * {@inheritdoc}
     */
    public function getEmailVars(): array
    {
        $vars = parent::getEmailVars();

        $vars['USER_USERNAME'] = $this->getAccount()->getUsername();
        $vars['USER_EMAIL'] = $this->getAccount()->getEmail();
        $vars['USER_FULL_NAME'] = $this->getAccount()->getUserDetails()->name();
        $vars['USER_PASSWORD'] = $this->getPassword();
        $vars['USER_ROLE'] = $this->getAccount()->getRole()->getName();

        return $vars;
    }
}
