<?php

/**
 * Questo file è parte di Pongho.
 *
 * @author    Daniele Termini
 * @copyright Web Agency Meta Line S.r.l.
 * @package   Application\Core
 */

namespace Application\Core\Notification;

use Application\Core\Entity\LanguageInterface;
use Application\Core\Entity\NotificationTemplateInterface;

/**
 * NotificationInterface
 */
interface NotificationInterface
{
    /**
     * Il nome della notifica da registrare nella collection, deve essere univoco per ogni notifica.
     */
    public function getName(): string;

    /**
     * Restituisce il titolo tradotto per la notifica.
     */
    public function getTitle(): string;

    /**
     * Opzioni per gestire la personalizzazione del template in amministrazione.
     *
     * Indica al controller che gestisce la form per la personalizzazione del template quali campi sono modificabili.
     * Es: nell’email all’utente non sarà possibile modificare il campo "To:" ma sarà possibile
     * modificare il campo "From:", invece nell’email all’amministratore sarà possibile modificare anche il campo
     * "To:" per consentire destinatari multipli. Altre notifiche non avranno la parte di notifica all’utente o
     * all’amministratore (ad esempio recupero password).
     */
    public function getOptions(): NotificationOptions;

    /**
     * Restituisce un elenco di chiavi da poter utilizzare nel template per inserire i valori dinamici.
     */
    public function getVars(): array;

    /**
     * Restituisce un elenco di valori le cui chiavi devono essere le stesse dell’array restituito da {@see self::getVars()}.
     */
    public function getEmailVars(): array;

    /**
     * Restituisce la lingua.
     */
    public function getLanguage(): LanguageInterface;

    /**
     * Restituisce il template di default, che può essere personalizzato, da usare per l’invio.
     */
    public function getDefaultTemplate(): NotificationTemplateInterface;
}
